<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>

  <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <xsl:choose>
      <xsl:when test="$xslShowHelp = 'true'">
        <xsl:call-template name="StyleSheetHelp"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="InRoads">
          <xsl:for-each select="SurveyFieldbook">
            <xsl:text>NazevBodu,Y,X,Z,Definice prvku&#xd;</xsl:text>
            <xsl:for-each select="SurveyPointList/SurveyPoint">
              <xsl:value-of select="@name"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
              <xsl:text>,</xsl:text>
              <xsl:value-of select="@code"/>
              <xsl:text>&#xd;</xsl:text>
            </xsl:for-each>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
           Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje minimálně jeden bodový prvek.
	</p>

<p class="normal1">Pro nejlepší výsledek spusťte výpis z panelu Detaily. Vyberte všechny bodové prvky v Průzkumníku projektu, které jsou v panelu Detaily.  Zvýrazněte řádky, které chcete mít ve výpisu, a pravým tlačítkem zvolte Výpis na vybraných položkách.
</p>
<p class="normal1">Spuštění výpisu z obecného nástroje výpisu zaměření nebo kliknutí pravým tlačítkem na grafický prvek provede výpis pouze na jednom vybraném prvku. 
</p>
            <p class="normal1">Jakmile je otevřený Průzkumník výpisů, zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
